/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.security.Principal;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.TimeZoneUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrRequestInfo {
    protected static final ThreadLocal<SolrRequestInfo> threadLocal = new ThreadLocal();
    protected SolrQueryRequest req;
    protected SolrQueryResponse rsp;
    protected Date now;
    protected HttpServletRequest httpRequest;
    protected TimeZone tz;
    protected ResponseBuilder rb;
    protected List<Closeable> closeHooks;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static SolrRequestInfo getRequestInfo() {
        return threadLocal.get();
    }

    public static void setRequestInfo(SolrRequestInfo info) {
        SolrRequestInfo prev = threadLocal.get();
        if (prev != null) {
            log.error("Previous SolrRequestInfo was not closed!  req=" + prev.req.getOriginalParams().toString());
            log.error("prev == info : {}", (Object)(prev.req == info.req ? 1 : 0), (Object)new RuntimeException());
        }
        assert (prev == null);
        threadLocal.set(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearRequestInfo() {
        try {
            SolrRequestInfo info = threadLocal.get();
            if (info != null && info.closeHooks != null) {
                for (Closeable hook : info.closeHooks) {
                    try {
                        hook.close();
                    }
                    catch (Exception e) {
                        SolrException.log((Logger)log, (String)"Exception during close hook", (Throwable)e);
                    }
                }
            }
        }
        finally {
            threadLocal.remove();
        }
    }

    public SolrRequestInfo(SolrQueryRequest req, SolrQueryResponse rsp) {
        this.req = req;
        this.rsp = rsp;
    }

    public SolrRequestInfo(HttpServletRequest httpReq, SolrQueryResponse rsp) {
        this.httpRequest = httpReq;
        this.rsp = rsp;
    }

    public Principal getUserPrincipal() {
        if (this.req != null) {
            return this.req.getUserPrincipal();
        }
        if (this.httpRequest != null) {
            return this.httpRequest.getUserPrincipal();
        }
        return null;
    }

    public Date getNOW() {
        if (this.now != null) {
            return this.now;
        }
        long ms = 0L;
        String nowStr = this.req.getParams().get("NOW");
        ms = nowStr != null ? Long.parseLong(nowStr) : this.req.getStartTime();
        this.now = new Date(ms);
        return this.now;
    }

    public TimeZone getClientTimeZone() {
        if (this.tz == null) {
            this.tz = TimeZoneUtils.parseTimezone(this.req.getParams().get("TZ"));
        }
        return this.tz;
    }

    public SolrQueryRequest getReq() {
        return this.req;
    }

    public SolrQueryResponse getRsp() {
        return this.rsp;
    }

    public ResponseBuilder getResponseBuilder() {
        return this.rb;
    }

    public void setResponseBuilder(ResponseBuilder rb) {
        this.rb = rb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCloseHook(Closeable hook) {
        SolrRequestInfo solrRequestInfo = this;
        synchronized (solrRequestInfo) {
            if (this.closeHooks == null) {
                this.closeHooks = new LinkedList<Closeable>();
            }
            this.closeHooks.add(hook);
        }
    }

    public static ExecutorUtil.InheritableThreadLocalProvider getInheritableThreadLocalProvider() {
        return new ExecutorUtil.InheritableThreadLocalProvider(){

            public void store(AtomicReference ctx) {
                SolrRequestInfo me = SolrRequestInfo.getRequestInfo();
                if (me != null) {
                    ctx.set(me);
                }
            }

            public void set(AtomicReference ctx) {
                SolrRequestInfo me = (SolrRequestInfo)ctx.get();
                if (me != null) {
                    ctx.set(null);
                    SolrRequestInfo.setRequestInfo(me);
                }
            }

            public void clean(AtomicReference ctx) {
                SolrRequestInfo.clearRequestInfo();
            }
        };
    }
}

